/*
Opleiding	: Basisvaardigheden SQL Query's schrijven van SQLTeam.NL
Module		: Query performance

-- Voordat je begint eerst eventueel bestaande indexen verwijderen
DROP INDEX IF EXISTS [CreationDate] ON [dbo].[Posts]
DROP INDEX IF EXISTS [CreationDate_Score] ON [dbo].[Posts]
*/

/*
-	Waarom Query performance?
-	Meer mensen en systemen willen query'en --> data ophalen en bewerken
-	Dus we schrijven querys niet alleen functioneel, maar ook met performance in het achterhoofd
-	Zet execution plan aan
*/
SELECT TOP 100
	p.Id			AS PostId,
	p.CreationDate	AS AanmaakDatum,
	p.Title			AS Titel,
	p.Body			AS PostInhoud,
	p.Score			AS Score
FROM dbo.Posts p
WHERE p.Score > 100
ORDER BY p.score

/*
-	execution plan toe
		Clustered index scan
		TOP
		SELECT
		Memory grant!
*/
/*
-	Licht index(en) toe
		Heaps
		Clustered index
		Non clustered index
*/
-- DROP INDEX [CreationDate] ON [dbo].[Posts]
CREATE NONCLUSTERED INDEX [CreationDate] ON [dbo].[Posts] ([CreationDate])

SELECT TOP 100
	p.Id			AS PostId,
	p.CreationDate	AS AanmaakDatum,
	p.Title			AS Titel,
	p.Body			AS PostInhoud,
	p.Score			AS Score
FROM dbo.Posts p
WHERE p.CreationDate BETWEEN '2009-01-01 10:00' AND '2009-01-01 11:01'
ORDER BY p.score

/*
-	Licht execution plan toe
		Index seek
		Key lookup
*/

-- DROP INDEX [CreationDate_Score] ON [dbo].[Posts]
CREATE NONCLUSTERED INDEX [CreationDate_Score] ON [dbo].[Posts] ([CreationDate],[Score])

SELECT
	p.Id			AS PostId,
	p.CreationDate	AS AanmaakDatum,
--	p.Body			AS PostInhoud,
--	p.Title			AS Title,
	p.Score			AS Score
FROM dbo.Posts p
WHERE p.CreationDate BETWEEN '2009-01-01' AND '2009-02-01'
-- WHERE p.CreationDate BETWEEN '2009-01-01' AND '2009-04-01'
ORDER BY p.Score

/*
-	Licht het gebruik van de index CreationDate_Score in het execution plan toe
-	Licht de term 'Covering index' toe
-	Licht toe wat er gebeurt wanneer het veld body wordt toegevoegd
-	Licht toe wat er gebeurt wanneer het filter naar 1 april 2009 wordt uitgebreid
-	Licht toe wat er gebeurt wanneer het veld titel ipv van body wordt gebruikt
*/

/*
-	Gebruik aantal indexen per tabel
-	Denk aan verwijderen van tijdelijke indexen
*/
